'
' variable freq driver 07-03-23
' Microcontroller used: Microchip Technology 12F617
' microchip.com
' PicBasic Pro Code: micro-Engineering Labs, Inc.
' melabs.com
'-------Program Desciption--------
' To produce variable pulses to drive the H bridge. The switch connected to GP2 when open
'puts the bridge into sleep mode. The potentiometer on GP4 allows you to adjust the drive 
'frequency for maximum lift of the aluminium ring. The lower the frequency the higher
'the drive current
#CONFIG
  __CONFIG   _CP_OFF & _BOR_OFF & _MCLRE_ON & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _IOSCFS_8MHZ & _WRT_OFF
   #ENDCONFIG
  
 

 
DEFINE OSC 8  'oscillator 8MHz
Define ADC_BITS 10
define ADC_SAMPLEUS 1 
Define  ADC_CLOCK    3     ' Set clock source (3=rc)


OSCTUNE = %00000000  'osc tuned to factory setting


 CMCON0.7 = 0  'comparitor off
 VRCON.7 = 0' comparitor voltage reference module off 
 ADCON0 = %10001111  'ADC right justified ch3
 
 INTCON.7 = 0  'interrups off
 INTCON.6 = 0 'pher interrupts off
OPTION_REG.7 = 1 'pull ups disabled 
 


 
 TRISIO = %00011100 'GP2, GP3 (MCRL) and GP4 inputs rest outputs
 ANSEL = %00010000 'all GP digital except GP4 ADC input 
 
  '------------Variable-------------
  a var word 
  b var word
   

  '----------Initialization---------
   GPIO.1 = 0  ' H bridge in sleep mode
   GPIO.0 = 0  ' H bridge in sleep mode
  a = 2048
  b = 4096

   
'------------Main Code------------
 
 
     Main:
    
    if GPIO.2 = 0 then goto Rest
    if GPIO.2 = 1 then goto Lift
    Rest:
    GPIO.1 = 0  ' H bridge in sleep mode
    GPIO.0 = 0  ' H bridge in sleep mode
    goto Main
    Lift:
    ADCIN 3, a ' read voltage on ADC3 GP4 and write answer in a
    b = 2*a
    GPIO.1 = 1
    GPIO.0 = 0
    pauseus b' b 512 to 2048us
   
    ADCIN 3, a ' read voltage on ADC3 GP4 and write answer in a .Reason
    'for two ADC readings is to make the mark space ratio equal on the coil
    'drive waveform
    b = 2*a
    GPIO.1 = 0
    GPIO.0 = 1
    pauseus b' b 512 to 2048us
  
    goto Main
 
   
